﻿// ZIPPER  by Homepapa
//
// This script displays and operates a horizontal zipper.
// Use as follows:
// 1. Provide a <div id="zipper"> with absolute or relative positioning.
//    That's where the zipper will be installed.
// 2. Provide three images with the characters "o", "c" and "s" in their names:
//    ---o--.---    shows a part of the open zipper
//    ---c--.---    shows a part of the closed zipper
//    ---s--.---    shows the slider.
//    The slider will be moved to the left or right, and the open or closed
//    zipper images will be repeated on the left and right side of the slider.
//    The horizontal width od the open and closed zipper images will be used
//    to step the movement. It is recommended that all three images use
//    transparent background. Sample images for three sizes of zippers are
//    included.
// 3. Include this script file in your page.
// 4. on load, call zipper_init() with three arguments:
//       ---*--.---     the generic name of the three images. Use the name
//                      of one of the files and replace the variable character
//                      by an asterisk. The name can contain relative or absolute
//                      path information also.
//       nn             specify by how many pixels the slider will be moved out
//                      of the left side of the DIV when moving to left
//       pp             a percentage value that specifies the initial position
//                      of the slider.
//       hh             zipper speed: step frequency in 1/100 seconds
//
// zipper_init() will install additional DIVs within your "zipper" DIV,
// load the images into them, place the slider at its initial position
// and install event handlers that start slider movement when the slider
// is clicked onto and deal with window resizing.
  


// Establish global variables

var zipper_zip_width,            // width of the zip_image (height of "zipper" DIV)
    zipper_slider_middle,        // distance of slider center from slider back end
    zipper_slider_length,        // length of the slider
    zipper_step_width,           // zipper step width
    zipper_step_speed,           // time delay between 2 steps in 1/100 seconds
    zipper_start_position,       // zipper start position in percent
    zipper_overall_length,       // width of the zipper div
    zipper_div_left,             // left div with closed zipper
    zipper_div_right,            // right div with open zipper
    zipper_div_slider,           // center div with slider in it
    zipper_generic_image,        // aaa*bbb.ccc where * is "o(pen)", "c(lose)" or "s(lide)"
    zipper_img_o,                // image elements
    zipper_img_c,
    zipper_img_s,
    zipper_div                   // grab hold of the "zipper" DIV
    ;

var zipper_init_status = 0 ;   // how far has the initialistion already gone?
  


function zipper_init(imgnam,imgmid,perc,speed) {
    
  if(zipper_div = document.getElementById("zipper")) {
    // We have a DIV with the Id of "zipper".
    // That's where we will place our zipper into.
      
    // 1. "zipper" must contain three more DIVs, "zipl", "zipr" and "zips".
    //    If these DIVs aren't already created, we do so now.
    if(zipper_init_status == 0) {
      // - - - - - - - - - - - -
      // create the 3 inner DIVs
      // - - - - - - - - - - - -
      // First thing, let's make ready in the three image names.
      astpos = imgnam.indexOf("*") ;               // position of asterisk
      if(astpos < 0) {                             // none
        astpos = imgnam.indexOf(".") ;             // strip extension
        if(astpos < 0) {                           // no extension
          alert("The function zipper_init is called with an invalid first argument."
              + "\nThe first argument should specify a generic name for the three zipper "
              + "images. If the images are \"zipperc.gif\", \"zippero.gif\" and \"zippers.gif\", "
              + "then the argument should be \"zipper*.gif\"."
              + "\nWithout these three images, the zipper cannot work correctly.") ;
          return false ;
        }
        var zipimc = imgnam.substr(0,astpos) + "c" + imgnam.substr(astpos) ;
        var zipimo = imgnam.substr(0,astpos) + "o" + imgnam.substr(astpos) ;
        var zipims = imgnam.substr(0,astpos) + "s" + imgnam.substr(astpos) ;
      }
      else {
        var zipimc = imgnam.substr(0,astpos) + "c" + imgnam.substr(astpos+1) ;
        var zipimo = imgnam.substr(0,astpos) + "o" + imgnam.substr(astpos+1) ;
        var zipims = imgnam.substr(0,astpos) + "s" + imgnam.substr(astpos+1) ;
      }
      zipper_start_position = perc ;
      zipper_slider_middle = imgmid ;
      zipper_step_speed = speed ;
        
      // Now, within the DIV "zipper", let's create three new DIVs with an image in each one.
      // First, get the background color from zipper
      if(zipper_div.currentStyle) higrufa = zipper_div.currentStyle.backgroundColor ;
      if(document.defaultView)    higrufa = document.defaultView.getComputedStyle(zipper_div, '').getPropertyValue("background-color");
      // zipper_div.style.backgroundColor = "white" ;
      zipper_div.style.overflow = "hidden" ;

      // (a) the left one with the closed zipper in it
      zipper_div_left = document.createElement("DIV") ;
      zipper_div.appendChild(zipper_div_left) ;
      zipper_div_left.id = "zipl" ;
      zipper_div_left.style.background = higrufa + " url(" + zipimc + ") left center repeat-x" ;
      zipper_div_left.style.position = "absolute" ;
      zipper_div_left.style.padding = "0px" ;
      zipper_div_left.style.top = "0px" ;
      zipper_div_left.style.left = "0px" ;
      zipper_div_left.style.zIndex = 1 ;
      zipper_img_c = document.createElement("IMG") ;
      zipper_div_left.appendChild(zipper_img_c) ;
      zipper_img_c.src = zipimc ;
        
      // (b) the right one with the open zipper
      zipper_div_right = document.createElement("DIV") ;
      zipper_div.appendChild(zipper_div_right) ;
      zipper_div_right.id = "zipr" ;
      zipper_div_right.style.background = higrufa + " url(" + zipimo + ") left center repeat-x" ;
      zipper_div_right.style.position = "absolute" ;
      zipper_div_right.style.top = "0px" ;
      zipper_div_right.style.left = "0px" ;
      zipper_div_right.style.zIndex = 2 ;
      zipper_img_o = document.createElement("IMG") ;
      zipper_div_right.appendChild(zipper_img_o) ;
      zipper_img_o.src = zipimo ;

      // (c) the middle one with the slider in it
      zipper_div_slider = document.createElement("DIV") ;
      zipper_div.appendChild(zipper_div_slider) ;
      zipper_div_slider.id = "zips" ;
      zipper_div_slider.style.zIndex = 3 ;
      zipper_img_s = document.createElement("IMG") ;
      zipper_div_slider.appendChild(zipper_img_s) ;
      zipper_img_s.src = zipims ;

      zipper_zip_width = 0 ;
      zipper_slider_length = 0 ;
      zipper_step_width = 0 ;
        
      zipper_init_status = 1 ;
    }
      
    if(zipper_init_status == 1) {
      // We don't know the image dimensions yet.
      // Sometimes, the images take longer to load.
      // If so, call ourselfes again, after a while.
      if(zipper_img_c.complete) zipper_step_width = zipper_img_c.width ;
      if(zipper_img_o.complete) {
        zipper_step_width = zipper_img_o.width ;
        zipper_zip_width = zipper_img_o.height ;
      }
      if(zipper_img_s.complete) {
        zipper_zip_width = zipper_img_s.height ;
        zipper_slider_length = zipper_img_s.width ;
      }
      if(zipper_step_width * zipper_zip_width * zipper_slider_length == 0) {
        window.setTimeout("zipper_init(\"imgnam\"," + perc + ")",10) ;
        return false ;
      }
      // we have all dimensions now
      // therefore we can hide the images again.
      zipper_init_status = 2 ;
      zipper_img_c.style.display = "none" ;
      zipper_img_o.style.display = "none" ;
      zipper_img_s.style.display = "none" ;
        
      zipper_div.style.height = zipper_zip_width + "px" ;
      zipper_div_left.style.height = zipper_zip_width + "px" ;
      zipper_div_right.style.height = zipper_zip_width + "px" ;
      zipper_div_slider.style.height = zipper_zip_width + "px" ;
    }

    // Now, the DIVs are there and the dimensions are known.
    // Mainly for the center DIV with the slider in it,
    // we can do all the remaining specifications.

    zipper_new_size() ;

    work = zipper_slider_length + "px" ;
    zipper_div_slider.style.width = work ;
    work = zipper_zip_width + "px" ;
    zipper_div_slider.style.height = work ;
    zipper_div_slider.style.background = "none" ;
    zipper_div_slider.style.position = "absolute" ;
    zipper_div_slider.style.top = "0px" ;
    var slider = document.createElement("IMG") ;
    zipper_div_slider.appendChild(slider) ;
    slider.src = zipper_img_s.src ;
    slider.style.width = zipper_slider_length + "px" ;
    slider.style.height = zipper_zip_width + "px" ;
    slider.style.display = "block" ;
    slider.alt = "Slider" ;
    slider.onclick = zip_the_zipper ;


    window.onresize = zipper_new_size ;
  }
  else alert("There was a call to the function that initializes a zipper."
           + "\nHowever no DIV with the id of \"zipper\" could be found."
           + "\nA zipper was therefore not installed, but this souldn't"
           + "\nhave any side-effects on this side.") ;
}


// Utility function to determine the width of an element
function elemWidth(e) {
  if (e.clip && e.clip.width)
      return e.clip.width;
  if (e.style.pixelWidth)
      return e.style.pixelWidth;
  if (e.offsetWidth)
      return e.offsetWidth;
  return -1;
}

// Utility function to call zipper_move() with a default direction
function zip_the_zipper() {
  zipper_move(0) ;
}

// event handler when the window-size has been changed
function zipper_new_size() {
  // get the new DIV width,
  // calculate the start position
  // and the inner DIV widths
  zipper_overall_length = elemWidth(zipper_div) ;
  startposition = Math.round(zipper_overall_length*zipper_start_position/100) ;
  zipper_div_left.style.width = startposition + "px" ;
  work = zipper_overall_length - startposition - zipper_slider_length + zipper_slider_middle ;
  work += "px" ;
  zipper_div_right.style.width = work ;
  work = startposition - zipper_slider_middle + zipper_slider_length ;
  zipper_div_right.style.left = work + "px" ;
  work = startposition - zipper_slider_middle ;
  zipper_div_slider.style.left = work + "px" ;
}


// ===============
// Zipper movement
// ===============
function zipper_move(dir) {
  // move the slider by one step.
  // dir < 0   : move to the left
  // dir > 0   : move to the right
  // dir == 0  : establish a direction depending of the actual position
  if(dir == 0) {
    dir = (startposition < (zipper_overall_length/2)) ? 1 : -1 ;
  }
  var mystep = dir * zipper_step_width ;
  // do we need to take a step? only if we han't reached the far end yet
  var lets_go = false ;
  if((startposition > zipper_step_width) && (dir == -1)) lets_go = true ;
  if((startposition < zipper_overall_length - zipper_step_width) && (dir == 1)) lets_go = true ;
  
  if(lets_go) {
    startposition += mystep ;
    document.getElementById("zipl").style.width = startposition + "px" ;
    work = zipper_overall_length - startposition - zipper_slider_length + zipper_slider_middle ;
    if(work < 0) work = 0 ;
    work += "px" ;
    document.getElementById("zipr").style.width = work ;
    work = startposition - zipper_slider_middle + zipper_slider_length ;
    document.getElementById("zipr").style.left = work + "px" ;
    work = startposition - zipper_slider_middle ;
    document.getElementById("zips").style.left = work + "px" ;
    window.setTimeout("zipper_move(" + dir + ")",zipper_step_speed) ;
  }
}


